//Listing 17.1. Klasa Stack przechowujca wartoci znakowe
#include <iostream>
using namespace std;
class Stack {
  char *items;                   // stos przechowujcy symbole znakowe
  int top, size;                 // biecy wierzchoek stosu, cakowity rozmiar
  Stack(const Stack&);
  operator = (const Stack&);
public:
  Stack(int);                   // konstruktor konwertujcy
  void push(char);              // umie na stosie
  char pop();                   // zdejmij ze stosu
  bool isEmpty() const;         // czy stos jest pusty?
  ~Stack();                     // zwolnij pami na stercie
} ;

Stack::Stack(int sz = 100) : size(sz),top(0)
{ items = new char[sz];        // przydziel pami na stercie
  if (items==0)
  { cout << "Brak pamici\n"; exit(1); } }

void Stack::push (char c)
  { if (top < size)            // normalny przypadek: umie symbol
      items[top++] = c;
    else                       // obsu przepenienie stosu
       { char *p = new char[size*2]; // przydziel wicej pamici na stercie
         if (p == 0)           // sprawd powodzenie
             { cout << "Brak pamici\n"; exit(1); }
         for (int i=0; i < size; i++) // skopiuj biec zawarto sterty
             p[i] = items[i];
             delete [] items; // zwolnij pami na stercie
             items = p;       // podcz nowy obszar pamici
             size *= 2;       // uaktualnij nowy rozmiar stosu
             cout << "Nowy rozmiar: " << size << endl;
          items[top++] = c; } } // umie symbol na stosie

char Stack::pop()
{ return items[--top]; }       // bezwarunkowo zdejmij

bool Stack::isEmpty() const   // czy zostaa jeszcze warto do zdjcia?
{ return top == 0; }

Stack::~Stack()
{ delete [] items; }          // zwolnij pami na stercie

int main()
{
  char data[] = "abcdefghij"; // dane wejciowe
  Stack s(4);                 // obiekt stosu
  int n = sizeof(data)/sizeof(char)-1; // liczba danych wejciowych
  cout << "Dane pocztkowe: ";
  for (int j = 0; j < n; j++) // wywietl dane pocztkowe
  { cout << data[j] << " "; }
  cout << endl;
  for (int i = 0; i < n; i++) // umie dane na stosie
    s.push(data[i]);
  cout << "Dane odwrcone: ";
  while (!s.isEmpty())         // zdejmuj ze stosu do czasu jego oprnienia
    cout << s.pop() << " ";
  cout << endl;
  return 0;
}
